<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('peninjauan_peralihan', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('peninjauan_id');
            $table->integer('urutan');
            $table->year('pada_tahun')->nullable();
            $table->string('dikuasai_oleh')->nullable();
            $table->enum('dialihkan', ['jual', 'hibah', 'waris', 'lainnya'])->nullable();
            $table->decimal('luas', 10, 2)->nullable();
            $table->timestamps();
            
            $table->index(['peninjauan_id', 'urutan']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('peninjauan_peralihan');
    }
};
