<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Auth;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    public function register()
    {
        //
    }

    public function boot()
    {
        Paginator::useBootstrapFour();

        // =========================================
        // ROLE-BASED BLADE DIRECTIVES
        // =========================================

        Blade::if('role', function ($role) {
            return Auth::check() && Auth::user()->hasRole($role);
        });

        Blade::if('anyrole', function (...$roles) {
            return Auth::check() && Auth::user()->hasAnyRole($roles);
        });

        Blade::if('allroles', function (...$roles) {
            return Auth::check() && Auth::user()->hasAllRoles($roles);
        });

        // =========================================
        // PERMISSION-BASED BLADE DIRECTIVES
        // =========================================

        Blade::if('permission', function ($permission) {
            return Auth::check() && Auth::user()->can($permission);
        });

        Blade::if('anypermission', function (...$permissions) {
            return Auth::check() && Auth::user()->hasAnyPermission($permissions);
        });

        Blade::if('allpermissions', function (...$permissions) {
            return Auth::check() && Auth::user()->hasAllPermissions($permissions);
        });

        // =========================================
        // SPECIFIC ROLE CHECKS (sesuai sistem Anda)
        // =========================================

        Blade::if('superadmin', function () {
            return Auth::check() && Auth::user()->hasRole('superadmin');
        });

        Blade::if('supervisor', function () {
            return Auth::check() && Auth::user()->hasRole('supervisor');
        });

        Blade::if('staff', function () {
            return Auth::check() && Auth::user()->hasRole('staff');
        });

        Blade::if('administrator', function () {
            return Auth::check() && Auth::user()->hasRole('administrator');
        });

        Blade::if('guest', function () {
            return Auth::check() && Auth::user()->hasRole('guest');
        });

        // =========================================
        // FEATURE-BASED ACCESS CHECKS
        // =========================================

        // Can manage SKPT
        Blade::if('canManageSkpt', function () {
            return Auth::check() && Auth::user()->hasAnyRole(['superadmin', 'supervisor', 'staff', 'administrator']);
        });

        // Can verify documents
        Blade::if('canVerify', function () {
            return Auth::check() && Auth::user()->hasAnyRole(['superadmin', 'supervisor']);
        });

        // Can manage master data
        Blade::if('canManageMaster', function () {
            return Auth::check() && Auth::user()->hasAnyRole(['superadmin', 'administrator']);
        });

        // Can manage users
        Blade::if('canManageUsers', function () {
            return Auth::check() && Auth::user()->can('user.view');
        });
    }
}
