<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SpSiptStatusHistory extends Model
{
    use HasFactory;

    protected $table = 'sp_sipt_status_history';

    protected $fillable = [
        'sp_sipt_id',
        'status_from',
        'status_to',
        'catatan',
        'changed_by',
        'changed_at'
    ];

    protected $casts = [
        'changed_at' => 'datetime'
    ];

    /**
     * Relationships
     */
    public function spSipt()
    {
        return $this->belongsTo(SpSipt::class, 'sp_sipt_id');
    }

    public function changedBy()
    {
        return $this->belongsTo(User::class, 'changed_by');
    }

    /**
     * Accessors
     */
    public function getStatusFromLabelAttribute()
    {
        return $this->getStatusLabel($this->status_from);
    }

    public function getStatusToLabelAttribute()
    {
        return $this->getStatusLabel($this->status_to);
    }

    /**
     * Methods
     */
    public function getStatusLabel($status)
    {
        if (!$status) return '-';
        
        return match($status) {
            'draft' => 'Draft',
            'submitted' => 'Diajukan',
            'in_review' => 'Sedang Ditinjau',
            'approved' => 'Disetujui',
            'rejected' => 'Ditolak',
            default => $status
        };
    }

    public function getActionDescription()
    {
        $from = $this->getStatusLabel($this->status_from);
        $to = $this->getStatusLabel($this->status_to);
        
        if (!$this->status_from) {
            return "Dibuat sebagai {$to}";
        }
        
        return "Diubah dari {$from} menjadi {$to}";
    }
}
