<?php

// ==========================================
// 4. Model SpSiptCatatan.php
// ==========================================

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SpSiptCatatan extends Model
{
    use HasFactory;

    protected $table = 'sp_sipt_catatan';

    protected $fillable = [
        'sp_sipt_id',
        'catatan',
        'jenis_catatan',
        'is_visible_to_pemohon',
        'created_by'
    ];

    protected $casts = [
        'is_visible_to_pemohon' => 'boolean'
    ];

    /**
     * Jenis catatan constants
     */
    const JENIS_INTERNAL = 'internal';
    const JENIS_FEEDBACK = 'feedback';
    const JENIS_REVISI = 'revisi';

    /**
     * Relationships
     */
    public function spSipt()
    {
        return $this->belongsTo(SpSipt::class, 'sp_sipt_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Scopes
     */
    public function scopeVisibleToPemohon($query)
    {
        return $query->where('is_visible_to_pemohon', true);
    }

    public function scopeInternal($query)
    {
        return $query->where('jenis_catatan', self::JENIS_INTERNAL);
    }

    public function scopeFeedback($query)
    {
        return $query->where('jenis_catatan', self::JENIS_FEEDBACK);
    }

    public function scopeRevisi($query)
    {
        return $query->where('jenis_catatan', self::JENIS_REVISI);
    }

    /**
     * Accessors
     */
    public function getJenisCatatanLabelAttribute()
    {
        return match($this->jenis_catatan) {
            self::JENIS_INTERNAL => 'Catatan Internal',
            self::JENIS_FEEDBACK => 'Feedback',
            self::JENIS_REVISI => 'Revisi',
            default => 'Unknown'
        };
    }

    public function getJenisCatatanBadgeClassAttribute()
    {
        return match($this->jenis_catatan) {
            self::JENIS_INTERNAL => 'badge-secondary',
            self::JENIS_FEEDBACK => 'badge-info',
            self::JENIS_REVISI => 'badge-warning',
            default => 'badge-light'
        };
    }
}