<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SkptAnak extends Model
{
    use HasFactory;

    protected $table = 'skpt_anak';

    protected $fillable = [
        'skpt_id',
        'nama_anak',
        'usia',
    ];

    protected $casts = [
        'skpt_id' => 'integer',
        'usia' => 'integer',
    ];

    // Relasi ke model Skpt (jika ada)
    public function skpt()
    {
        return $this->belongsTo(SKPTApplication::class, 'skpt_id');
    }
}
