<?php


namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Wildside\Userstamps\Userstamps;
use Illuminate\Database\Eloquent\SoftDeletes;

class Person extends Model
{
    use HasFactory;

    protected $table = 'people';
    
    protected $fillable = [
        'nama',
        'tempat_lahir',
        'tanggal_lahir',
        'pekerjaan',
        'alamat',
        'no_ktp',
        'no_telepon'
    ];

    protected $casts = [
        'tanggal_lahir' => 'date'
    ];

    // Relationships
    public function baParticipants()
    {
        return $this->hasMany(BaParticipant::class);
    }

    public function landBoundaries()
    {
        return $this->hasMany(LandBoundary::class, 'saksi_person_id');
    }

    public function landOwnershipHistory()
    {
        return $this->hasMany(LandOwnershipHistory::class, 'owner_person_id');
    }

    // Accessor
    public function getFullNameAttribute()
    {
        return $this->nama;
    }
}