<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class PeninjauanCoordinateUtm extends Model
{
    use HasFactory;

    protected $table = 'utm_coordinates';

    protected $fillable = [
        'peninjauan_id',
        'point_number',
        'easting',
        'northing',
        'sequence'
    ];


    // Relationships
    public function peninjauan()
    {
        return $this->belongsTo(Peninjauan::class, 'peninjauan_id');
    }

    // Methods
    public function toArray()
    {
        return [
            'point' => $this->point_number,
            'easting' => $this->easting,
            'northing' => $this->northing,
            'sequence' => $this->sequence
        ];
    }
}
