<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class LandOwnershipHistory extends Model
{
    use HasFactory;

    protected $table = 'land_ownership_history';
    
    protected $fillable = [
        'berita_acara_id',
        'owner_person_id',
        'tahun_mulai',
        'tahun_selesai',
        'luas_m2',
        'cara_peralihan',
        'keterangan',
        'urutan'
    ];

    protected $casts = [
        'luas_m2' => 'decimal:2'
    ];

    // Relationships
    public function beritaAcara(): BelongsTo
    {
        return $this->belongsTo(BeritaAcara::class);
    }

    public function owner(): BelongsTo
    {
        return $this->belongsTo(Person::class, 'owner_person_id');
    }

    // Scopes
    public function scopeOrderedBySequence($query)
    {
        return $query->orderBy('urutan');
    }
}
