<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class LandBoundary extends Model
{
    use HasFactory;

    protected $table = 'land_boundaries';
    
    protected $fillable = [
        'berita_acara_id',
        'direction',
        'boundary_type',
        'description',
        'saksi_person_id'
    ];

    // Relationships
    public function beritaAcara(): BelongsTo
    {
        return $this->belongsTo(BeritaAcara::class);
    }

    public function saksi(): BelongsTo
    {
        return $this->belongsTo(Person::class, 'saksi_person_id');
    }
}