<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Kampung extends Model
{
    protected $table = 'kampung';
    protected $fillable = [
        'kode_kampung',
        'nama_kampung',
        'kecamatan_id',
        'alamat_kantor_kampung',
        'kode_pos',
        'nama_kepala_kampung',
        'nip',
        'golongan',
        'pangkat',
        'luas_wilayah',
        'jumlah_rt',
        'jumlah_rw',
        'jumlah_penduduk',
        'status',
        'warna',
        'geojson', // Konten JSON
        'geojson_file', // Nama file
    ];

    public function kecamatan()
    {
        return $this->belongsTo(Kecamatan::class, 'kecamatan_id');
    }

    public function rtrws()
    {
        return $this->hasMany(Rtrw::class, 'kampung_id');
    }
}