<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Wildside\Userstamps\Userstamps;

class CheckOut extends Model
{
       use HasFactory, Userstamps,SoftDeletes;

    protected $table = 'tr_checkout';

    protected $fillable = [
        'booking_id',
        'check_out_time',
        'notes',
        'created_by',
        'updated_by'
    ];

    protected $casts = [
        'check_out_time' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime'
    ];

    // Relationship dengan Booking
    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    // Relationship dengan User yang membuat check-out
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // Relationship dengan User yang mengupdate check-out
    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    // Accessor untuk format tanggal Indonesia
    public function getCheckOutTimeFormattedAttribute()
    {
        return $this->check_out_time ? $this->check_out_time->format('d/m/Y H:i') : null;
    }

    // Scope untuk filter berdasarkan tanggal
    public function scopeToday($query)
    {
        return $query->whereDate('check_out_time', today());
    }

    public function scopeThisMonth($query)
    {
        return $query->whereMonth('check_out_time', now()->month)
                    ->whereYear('check_out_time', now()->year);
    }
}