<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BeritaAcaraPeninjauan extends Model
{
    use HasFactory;

    protected $table = 'berita_acara_peninjauan';

    protected $fillable = [
        'peninjauan_id',
        'nomor_berita_acara',
        'type',
        'status',
        'status_verifikasi',
        'verifikator_id',
    ];

    // Relasi ke Peninjauan
    public function peninjauan()
    {
        return $this->belongsTo(Peninjauan::class, 'peninjauan_id');
    }

    // Relasi ke User sebagai verifikator
    public function verifikator()
    {
        return $this->belongsTo(User::class, 'verifikator_id');
    }
}
