# ✅ Deployment Checklist untuk Shared Hosting cPanel

## Status Perbaikan Kode ✅

### ✅ Upload Map Image - **SUDAH DIPERBAIKI**
- ✅ Method `store()` - Menggunakan `file_put_contents()` dengan error handling
- ✅ Method `update()` - Menggunakan `file_put_contents()` dengan error handling
- ✅ Auto-create directory jika belum ada
- ✅ Logging error untuk debugging
- ✅ Graceful failure (tidak crash jika gagal)

### ✅ Upload File Dokumen - **SUDAH AMAN**
- ✅ Menggunakan Laravel `store()` method yang kompatibel dengan shared hosting
- ✅ File kwitansi
- ✅ File dokumen_template

### ✅ Error Handling - **SUDAH LENGKAP**
- ✅ Try-catch pada semua operasi file
- ✅ Logging menggunakan Laravel Log facade
- ✅ Transaction rollback pada error

## 🚀 Langkah Deploy ke Shared Hosting cPanel

### 1. Persiapan File

#### A. Upload File via FTP/File Manager
```
Upload semua file ke: /home/username/public_html
```

#### B. Struktur Folder
```
/home/username/public_html/
├── app/
├── bootstrap/
├── config/
├── database/
├── public/          ← Document root harus di sini
├── resources/
├── routes/
├── storage/         ← PENTING!
├── vendor/
├── .env
├── artisan
└── composer.json
```

### 2. Set Document Root di cPanel

1. Login ke **cPanel**
2. Cari **"Domains"** atau **"Document Root"**
3. Set document root ke: `/home/username/public_html/public`

### 3. Konfigurasi Permission Folder ⚠️

**Via File Manager cPanel:**

Set permission folder berikut:

```bash
storage/                              → 755
storage/app/                          → 755
storage/app/public/                   → 755
storage/app/public/sp-sipt/           → 755 (buat folder ini!)
storage/app/public/sp-sipt/maps/      → 755 (buat folder ini!)
storage/app/public/sp-sipt/documents/ → 755 (buat folder ini!)
storage/logs/                         → 755
storage/framework/                    → 755
storage/framework/cache/              → 755
storage/framework/sessions/           → 755
storage/framework/views/              → 755

bootstrap/cache/                      → 755

public/storage/                       → 755 (symlink)
```

**PENTING:** Jangan gunakan permission 777 di shared hosting!

### 4. Buat Symbolic Link 🔗

#### Option A: Via Terminal SSH (Recommended)
```bash
cd /home/username/public_html
php artisan storage:link
```

#### Option B: Via cPanel Terminal
1. Buka **Terminal** di cPanel
2. Jalankan:
```bash
cd ~/public_html
php artisan storage:link
```

#### Option C: Manual (Jika artisan tidak bisa)
1. Buka **File Manager**
2. Masuk ke folder `public/`
3. Hapus folder/file `storage` jika ada
4. Klik **"+ Create"** atau **"New Symbolic Link"**
   - Source: `/home/username/public_html/storage/app/public`
   - Destination: `/home/username/public_html/public/storage`

### 5. Buat Folder yang Diperlukan 📁

**Via File Manager atau Terminal:**

```bash
mkdir -p storage/app/public/sp-sipt/maps
mkdir -p storage/app/public/sp-sipt/documents
chmod 755 storage/app/public/sp-sipt
chmod 755 storage/app/public/sp-sipt/maps
chmod 755 storage/app/public/sp-sipt/documents
```

### 6. Konfigurasi File .env 🔧

Edit file `.env` di root project:

```env
APP_NAME="WebGIS Biduk"
APP_ENV=production
APP_KEY=base64:xxx  # Generate dengan: php artisan key:generate
APP_DEBUG=false     # PENTING: False untuk production!
APP_URL=https://yourdomain.com

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=error     # Ubah ke 'error' untuk production

DB_CONNECTION=mysql
DB_HOST=localhost   # Atau 127.0.0.1
DB_PORT=3306
DB_DATABASE=your_database_name
DB_USERNAME=your_database_user
DB_PASSWORD=your_database_password

FILESYSTEM_DISK=public
FILESYSTEM_DRIVER=public

SESSION_DRIVER=file
SESSION_LIFETIME=120

CACHE_DRIVER=file
QUEUE_CONNECTION=sync
```

### 7. Konfigurasi .htaccess di public/ 📝

Pastikan file `public/.htaccess` berisi:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>

# Increase upload limits
php_value upload_max_filesize 50M
php_value post_max_size 50M
php_value max_execution_time 300
php_value max_input_time 300
php_value memory_limit 256M

# Allow specific file types
<FilesMatch "\.(jpg|jpeg|png|gif|svg|webp|pdf|doc|docx)$">
    Order allow,deny
    Allow from all
</FilesMatch>

# Disable ModSecurity for this directory (if causing issues)
<IfModule mod_security.c>
    SecFilterEngine Off
    SecFilterScanPOST Off
</IfModule>
```

### 8. Install Dependencies 📦

**Via SSH Terminal:**

```bash
cd /home/username/public_html

# Install Composer dependencies
composer install --optimize-autoloader --no-dev

# Generate application key (jika belum)
php artisan key:generate

# Clear cache
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# Optimize untuk production
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Migrate database (jika perlu)
php artisan migrate --force
```

### 9. Test Upload Manual 🧪

Buat file `test-upload.php` di root (hapus setelah test):

```php
<?php
// Test upload functionality
echo "<h2>Testing File Upload Capability</h2>";

$testDir = __DIR__ . '/storage/app/public/sp-sipt/maps';
$testFile = $testDir . '/test_' . time() . '.txt';
$testData = "Test upload at " . date('Y-m-d H:i:s');

// Test 1: Check if directory exists
echo "<h3>1. Directory Check</h3>";
echo "Directory: " . $testDir . "<br>";
echo "Exists: " . (file_exists($testDir) ? '✅ YES' : '❌ NO') . "<br>";
echo "Writable: " . (is_writable($testDir) ? '✅ YES' : '❌ NO') . "<br>";
echo "Permissions: " . (file_exists($testDir) ? substr(sprintf('%o', fileperms($testDir)), -4) : 'N/A') . "<br>";

// Test 2: Try to create directory
if (!file_exists($testDir)) {
    echo "<h3>2. Creating Directory</h3>";
    if (mkdir($testDir, 0755, true)) {
        echo "✅ Directory created successfully<br>";
    } else {
        echo "❌ Failed to create directory<br>";
    }
}

// Test 3: Try to write file
echo "<h3>3. File Write Test</h3>";
$result = file_put_contents($testFile, $testData);

if ($result !== false) {
    echo "✅ SUCCESS! File written: " . $testFile . "<br>";
    echo "File size: " . filesize($testFile) . " bytes<br>";
    echo "File contents: " . file_get_contents($testFile) . "<br>";
    
    // Clean up
    unlink($testFile);
    echo "<br>✅ Test file deleted<br>";
} else {
    echo "❌ FAILED! Cannot write file<br>";
    echo "Check permissions and PHP configuration<br>";
}

// Test 4: Check PHP functions
echo "<h3>4. PHP Functions Check</h3>";
$functions = ['file_put_contents', 'mkdir', 'chmod', 'unlink', 'file_exists', 'is_writable'];
foreach ($functions as $func) {
    echo $func . ": " . (function_exists($func) ? '✅ Available' : '❌ Disabled') . "<br>";
}

// Test 5: Check PHP limits
echo "<h3>5. PHP Configuration</h3>";
echo "upload_max_filesize: " . ini_get('upload_max_filesize') . "<br>";
echo "post_max_size: " . ini_get('post_max_size') . "<br>";
echo "max_execution_time: " . ini_get('max_execution_time') . "<br>";
echo "memory_limit: " . ini_get('memory_limit') . "<br>";
?>
```

Akses: `https://yourdomain.com/test-upload.php`

**Hasil yang diharapkan:**
- ✅ Directory exists: YES
- ✅ Directory writable: YES
- ✅ File write: SUCCESS
- ✅ All PHP functions available

### 10. Troubleshooting 🔧

#### A. Error 403 Forbidden

**Penyebab & Solusi:**

1. **Symbolic link belum dibuat**
   ```bash
   php artisan storage:link
   ```

2. **Permission salah**
   ```bash
   chmod 755 storage -R
   chmod 755 bootstrap/cache -R
   ```

3. **ModSecurity blocking**
   - Tambahkan di `.htaccess`:
   ```apache
   <IfModule mod_security.c>
       SecFilterEngine Off
   </IfModule>
   ```
   - Atau hubungi support hosting

4. **Folder belum dibuat**
   ```bash
   mkdir -p storage/app/public/sp-sipt/maps
   chmod 755 storage/app/public/sp-sipt/maps
   ```

#### B. Error 500 Internal Server Error

**Solusi:**

1. Cek error log:
   ```bash
   tail -f storage/logs/laravel.log
   # atau
   tail -f ~/public_html/error_log
   ```

2. Set permission yang benar:
   ```bash
   chmod 755 storage -R
   chmod 755 bootstrap/cache -R
   ```

3. Clear cache:
   ```bash
   php artisan cache:clear
   php artisan config:clear
   ```

4. Check `.env` file configuration

#### C. Gambar/File Tidak Muncul

**Solusi:**

1. Verifikasi symbolic link:
   ```bash
   ls -la public/storage
   # Harus menunjuk ke: ../storage/app/public
   ```

2. Cek permission folder storage:
   ```bash
   ls -la storage/app/public/sp-sipt/maps/
   ```

3. Pastikan URL di `.env` benar:
   ```env
   APP_URL=https://yourdomain.com
   ```

#### D. Upload File Gagal

**Solusi:**

1. Cek PHP limits di `.htaccess`:
   ```apache
   php_value upload_max_filesize 50M
   php_value post_max_size 50M
   ```

2. Cek di cPanel > PHP Version > Options:
   - upload_max_filesize: 50M
   - post_max_size: 50M
   - max_execution_time: 300

3. Pastikan folder writable:
   ```bash
   chmod 755 storage/app/public/sp-sipt/documents/
   ```

### 11. Optimasi untuk Production 🚀

```bash
# Optimize autoloader
composer dump-autoload --optimize

# Cache configuration
php artisan config:cache

# Cache routes
php artisan route:cache

# Cache views
php artisan view:cache

# Optimize
php artisan optimize
```

### 12. Security Checklist 🔒

- [ ] `APP_DEBUG=false` di `.env`
- [ ] `APP_ENV=production` di `.env`
- [ ] File `.env` tidak accessible dari web
- [ ] Folder `storage/` tidak accessible dari web (hanya via symlink)
- [ ] Permission tidak 777 (gunakan 755)
- [ ] Remove file `test-upload.php` setelah testing
- [ ] SSL/HTTPS aktif
- [ ] Database credentials aman
- [ ] Backup database secara berkala

### 13. Maintenance Mode

**Aktifkan maintenance:**
```bash
php artisan down --message="Sedang maintenance" --retry=60
```

**Nonaktifkan maintenance:**
```bash
php artisan up
```

### 14. Monitoring & Logging

**Check logs:**
```bash
# Laravel logs
tail -f storage/logs/laravel.log

# Apache/PHP error logs
tail -f ~/public_html/error_log
```

**Log rotation:**
- Gunakan cPanel > Metrics > Errors untuk melihat error log
- Set up log rotation jika file log terlalu besar

## 📞 Hubungi Support Hosting Jika:

1. ❌ PHP functions disabled (`file_put_contents`, `mkdir`, dll)
2. ❌ ModSecurity terus blocking request
3. ❌ Permission tidak bisa diubah
4. ❌ Symbolic link tidak bisa dibuat
5. ❌ PHP version terlalu lama (minimum PHP 8.0 untuk Laravel 9+)

**Informasi yang perlu disiapkan:**
- Screenshot error message
- Isi file `storage/logs/laravel.log`
- Isi file `error_log` dari root
- Permission folder (screenshot dari File Manager)
- Output dari `test-upload.php`

---

## ✅ Final Checklist

Sebelum go-live, pastikan semua ini sudah dilakukan:

- [ ] File uploaded ke shared hosting
- [ ] Document root sudah di-set ke `/public`
- [ ] Symbolic link `public/storage` sudah dibuat
- [ ] Permission folder `storage/` = 755
- [ ] Folder `sp-sipt/maps/` dan `sp-sipt/documents/` sudah dibuat
- [ ] File `.env` sudah dikonfigurasi dengan benar
- [ ] Database sudah di-migrate
- [ ] Composer dependencies sudah di-install
- [ ] Cache sudah di-clear
- [ ] Test upload manual berhasil (`test-upload.php`)
- [ ] SSL/HTTPS aktif
- [ ] `APP_DEBUG=false`
- [ ] Test create/update data dengan map image berhasil
- [ ] Test upload dokumen berhasil
- [ ] Semua error logs bersih

---

**🎉 Good Luck dengan Deployment Anda!**

Jika ada masalah, cek file `SHARED_HOSTING_FIX.md` untuk solusi detail.
